//********************************************************************
//  Pattern.java       Author: Lewis and Loftus
//
//  Solution to Programming Project 5.26 (5E, p. 288)
//********************************************************************

import java.awt.Graphics;
import java.awt.Color;

public class Pattern
{
   private final int SIZE = 20;
   private Color backgroundColor, circleColor;
   private boolean cross;

   //----------------------------------------------------------------
   //  Sets up the characteristics of this quilt pattern.
   //----------------------------------------------------------------
   public Pattern (Color color1, Color color2, boolean drawCross)
   {
      backgroundColor = color1;
      circleColor = color2;
      cross = drawCross;
   }

   //----------------------------------------------------------------
   //  Draws the quilt.
   //----------------------------------------------------------------
   public void draw (Graphics page, int row, int col)
   {
      int x = row * SIZE;
      int y = col * SIZE;

      page.setColor (backgroundColor);
      page.fillRect (x, y, SIZE, SIZE);

      page.setColor (circleColor);
      page.fillOval (x + 5, y + 5, SIZE-10, SIZE-10);

      if (cross)
      {
         page.setColor (Color.black);
         page.drawLine (x, y, x+SIZE, y+SIZE);
         page.drawLine (x+SIZE, y, x, y+SIZE);
      }
   }
}
